/*
 * TagEntry.h
 *
 *  Created on: 14.10.2009
 *      Author: stefan.detter
 */

#ifndef TAGDATA_H_
#define TAGDATA_H_

#include <QObject>
#include <QVariant>

class TagData
{
public:
	TagData();
    TagData(QString tagId, QString visualTagId, QString type);
	TagData(const TagData & other);
	virtual ~TagData();

	TagData& operator= (const TagData& other);

	void 	 addValue(QString key, QVariant value);

	QString  						tagId() const;
    QString  						visualTagId() const;
	QString  						tagType() const;
	bool	 						hasValue(QString key) const;
	QVariant 						value(QString key) const;

	bool operator == (const TagData& other) const;

private:
    QString 						m_tagId;
    QString 						m_visualTagId;
    QString							m_tagType;
	QMap<QString, QVariant> 		m_properties;
};

#endif /* TAGDATA_H_ */
